////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN

@protocol UserManagerProtocol;

/**
 * The {@link UserInformationProtocol} object provides information about the DIGIPASS object associated with
 * a specific login.
 */
NS_REFINED_FOR_SWIFT
@protocol UserInformationProtocol <NSObject>

/**
 * The user identifier, as provided by the integrator
 *
 * @return the user identifier
 */
- (NSString *)userIdentifier;

/**
 * The DIGIPASS-related serial number
 *
 * @return the serial number
 */
- (NSString *)digipassSerialNumber;

/**
 * The sequence number of the DIGIPASS instance that is not password protected
 *
 * @return the unprotected DIGIPASS instance's sequence number
 */
- (int)digipassSequenceNumberUnprotected;

/**
 * The sequence number of the DIGIPASS instance that is password protected
 *
 * @return the protected DIGIPASS instance's sequence number
 */
- (int)digipassSequenceNumberProtected;

/**
 * The UTC time used by the DIGIPASS instance
 *
 * @return the UTC time used by the DIGIPASS instance
 */
- (long)usedTimeSeconds;

/**
 * The recorded timeshift between the client and the server
 *
 * @return the client-server timeshift
 */
- (long)clientServerTimeShiftSeconds;

@end

NS_ASSUME_NONNULL_END
